# Phase 8: CMS Quick Start Guide

## 🚀 Getting Started in 5 Minutes

### Step 1: Execute Database Migration (REQUIRED)

Choose one of these methods:

#### Method A: phpMyAdmin (Easiest)
1. Open http://localhost/phpmyadmin
2. Select database: `obgyn_research_platform`
3. Click "SQL" tab
4. Open `database/cms_migration.sql` in text editor
5. Copy ALL contents
6. Paste into phpMyAdmin SQL box
7. Click "Go"
8. ✅ Done! You should see "Query OK" messages

#### Method B: MySQL Command Line
```bash
mysql -u obgyn_research_platform_user -p obgyn_research_platform < database/cms_migration.sql
# Password: 2UFAT605IQCLmyyd
```

### Step 2: Verify Installation

Run this SQL query in phpMyAdmin:
```sql
SHOW TABLES LIKE 'cms_%';
```

You should see 12 tables:
- cms_features
- cms_hero_sections
- cms_media
- cms_menu_items
- cms_menus
- cms_pages
- cms_posts
- cms_slider_items
- cms_sliders
- cms_stats
- cms_team_members
- cms_testimonials
- cms_widgets

### Step 3: Access CMS

1. Login to admin panel: http://localhost/obgyn-research-platform/admin/
2. Look for "CONTENT MANAGEMENT" section in sidebar
3. Click "Pages" to start managing content

---

## 📋 What's Available Now

### ✅ Working Features:

1. **Pages Management** (`admin/cms-pages.php`)
   - Create/edit/delete pages
   - Rich text editor (TinyMCE)
   - SEO optimization
   - Multi-language support
   - Draft/Published status

2. **Page Editor** (`admin/cms-pages-edit.php`)
   - Full WYSIWYG editor
   - Auto-slug generation
   - Meta tags (title, description, keywords)
   - Open Graph tags (Facebook, Twitter)
   - Canonical URLs
   - Robots meta tags

3. **Contact Info** (`admin/cms-contact.php`)
   - Company information
   - Contact details
   - Physical address
   - Social media links
   - Working hours
   - Map coordinates

### 🔄 Coming Soon:

- Blog Posts Management
- Media Library
- Menu Management
- Branding (Logo, Colors)
- Homepage Sections
- Team Members
- Announcements
- Email Templates Editor

---

## 🎯 Quick Tasks

### Create Your First Page

1. Go to **CMS → Pages**
2. Click **"Add New Page"**
3. Fill in:
   - Title: "About Us"
   - Content: Write your content using the editor
   - Status: Published
4. Click **"Create Page"**
5. View your page at: `http://localhost/obgyn-research-platform/public/page.php?slug=about-us`

### Update Contact Information

1. Go to **CMS → Contact Info**
2. Update:
   - Company name
   - Email addresses
   - Phone numbers
   - Address
   - Social media links
3. Click **"Save Contact Information"**

---

## 📁 File Structure

```
obgyn-research-platform/
├── admin/
│   ├── cms-pages.php           ✅ Pages listing
│   ├── cms-pages-edit.php      ✅ Page editor
│   ├── cms-contact.php         ✅ Contact info
│   ├── cms-posts.php           🔄 Coming soon
│   ├── cms-branding.php        🔄 Coming soon
│   ├── cms-media.php           🔄 Coming soon
│   └── sidebar.php             ✅ Updated with CMS menu
├── database/
│   ├── cms_migration.sql       ✅ Main migration file
│   ├── run_migration.php       ✅ Migration script
│   └── MIGRATION_INSTRUCTIONS.md ✅ Detailed instructions
├── public/
│   └── page.php                🔄 To be created
└── PHASE8_*.md                 ✅ Documentation
```

---

## 🔧 Troubleshooting

### Issue: "Table already exists" error
**Solution:** This is normal if re-running migration. The script uses `CREATE TABLE IF NOT EXISTS`.

### Issue: Can't see CMS menu in sidebar
**Solution:** 
1. Clear browser cache
2. Refresh page (Ctrl+F5)
3. Make sure you're logged in as admin

### Issue: TinyMCE editor not loading
**Solution:**
1. Check internet connection (TinyMCE loads from CDN)
2. Check browser console for errors
3. Try different browser

### Issue: "Access denied" when accessing CMS pages
**Solution:**
1. Make sure you're logged in
2. Check your user role (must be admin)
3. Check `requireAdmin()` function in includes/auth.php

---

## 📊 Database Tables Overview

| Table | Purpose | Records |
|-------|---------|---------|
| cms_pages | Static pages | 0 (start) |
| cms_posts | Blog posts | 0 (start) |
| cms_menus | Menu containers | 0 (start) |
| cms_menu_items | Menu items | 0 (start) |
| cms_media | Media library | 0 (start) |
| cms_widgets | Widgets | 0 (start) |
| cms_hero_sections | Hero sections | 0 (start) |
| cms_features | Features | 0 (start) |
| cms_testimonials | Testimonials | 0 (start) |
| cms_stats | Statistics | 0 (start) |
| cms_sliders | Sliders | 0 (start) |
| cms_slider_items | Slider items | 0 (start) |
| cms_team_members | Team members | 0 (start) |
| email_templates | Email templates | 6 (default) |
| settings | CMS settings | 16+ (default) |

---

## 🎨 Features Highlights

### Rich Text Editor (TinyMCE)
- Bold, italic, underline
- Headings (H1-H6)
- Lists (ordered, unordered)
- Links and images
- Tables
- Code blocks
- Full-screen mode
- HTML source view

### SEO Optimization
- Meta title (60 chars recommended)
- Meta description (160 chars recommended)
- Meta keywords
- Canonical URLs
- Robots meta tags
- Open Graph tags (Facebook)
- Twitter Card tags

### Multi-Language Support
- English (en)
- Arabic (ar)
- Easy to add more languages

---

## 📞 Need Help?

1. **Documentation:**
   - PHASE8_IMPLEMENTATION_SUMMARY.md - Full details
   - PHASE8_TODO.md - Task tracker
   - MIGRATION_INSTRUCTIONS.md - Setup help

2. **Code Comments:**
   - All PHP files have detailed comments
   - Check function descriptions

3. **Database Schema:**
   - See cms_migration.sql for table structures
   - Includes comments for each table

---

## ✨ Tips & Best Practices

1. **Always use Draft status** when creating new pages
2. **Fill in SEO fields** for better search engine visibility
3. **Use descriptive slugs** (e.g., "about-us" not "page1")
4. **Test pages** before publishing
5. **Keep content organized** with proper headings
6. **Optimize images** before uploading
7. **Use consistent formatting** across pages
8. **Regular backups** of database

---

## 🎯 Next Development Steps

After migration is complete, we'll implement:

1. **Blog Posts** (similar to pages, with categories)
2. **Media Library** (upload and manage images)
3. **Branding** (logo, colors, favicon)
4. **Menus** (header, footer navigation)
5. **Homepage Sections** (hero, features, testimonials)

---

**Ready to start?** Execute the migration and begin creating content! 🚀

**Questions?** Check the documentation files or review the code comments.

**Last Updated:** January 2025
